/*
 * Decompiled with CFR 0.152.
 */
package jace.cheat;

import jace.cheat.MemorySpy;
import jace.cheat.MetaCheats;
import jace.core.Computer;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemorySpyGrid
extends JPanel {
    ChangeListener viewportChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            MemorySpyGrid.this.repaint();
        }
    };
    Color[] gradient;
    static Color[] colorGradient = new Color[256];
    static Color[] bwGradient = new Color[256];
    boolean mousePresent = false;
    int mouseX;
    int mouseY;
    Modes mode = Modes.ACTIVITY;
    int zoomAmount = 5;
    int startAddress = 0;
    int endAddress = 65535;
    int columns = 1;
    int lastKnownWidth = 0;
    int lastKnownHeight = 0;
    boolean isDisplayActive = false;
    Thread redrawThread = null;
    static int UPDATE_INTERVAL;
    static int ACTIVITY_INCREMENT;
    static int ACTIVITY_DECREMENT;
    static int ACTIVITY_MAX;
    RAMListener memoryListener = null;
    Map<Integer, Integer> readActivity = new ConcurrentHashMap<Integer, Integer>();
    Map<Integer, Integer> writeActivity = new ConcurrentHashMap<Integer, Integer>();
    Map<Integer, Integer> pcActivity = new ConcurrentHashMap<Integer, Integer>();
    Set<Integer> activeRam = new ConcurrentSkipListSet<Integer>();
    Map<Integer, Integer> valueActivity = new ConcurrentHashMap<Integer, Integer>();
    Map<Integer, Integer> setBy = new ConcurrentHashMap<Integer, Integer>();
    Map<Integer, Integer> readBy = new ConcurrentHashMap<Integer, Integer>();

    public MemorySpyGrid() {
        this.initComponents();
        this.gradient = bwGradient;
    }

    @Override
    public void validate() {
        super.validate();
        if (Computer.getComputer() != null) {
            this.adjustSize();
        }
        if (this.getParent() != null) {
            JViewport viewport = (JViewport)this.getParent();
            viewport.removeChangeListener(this.viewportChangeListener);
            viewport.addChangeListener(this.viewportChangeListener);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mode == Modes.ACTIVITY) {
            for (int a = this.startAddress; a <= this.endAddress; ++a) {
                if (!this.activeRam.contains(a)) {
                    this.drawActivity(a, 0, 0, 0, (Graphics2D)g);
                    continue;
                }
                this.drawActivity(a, this.getInt(this.writeActivity.get(a)), this.getInt(this.readActivity.get(a)), this.getInt(this.pcActivity.get(a)), (Graphics2D)g);
            }
        } else {
            RAM ram = Computer.getComputer().getMemory();
            for (int a = this.startAddress; a <= this.endAddress; ++a) {
                this.drawValue(a, ram.readRaw(a) & 0xFF, (Graphics2D)g);
            }
        }
    }

    private void initComponents() {
        this.setBackground(new Color(1, 1, 1));
        this.setCursor(new Cursor(1));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MemorySpyGrid.this.formMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MemorySpyGrid.this.formMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MemorySpyGrid.this.formMouseEntered(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MemorySpyGrid.this.formMouseMoved(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.mousePresent = true;
    }

    private void formMouseExited(MouseEvent evt) {
        this.mousePresent = false;
    }

    private void formMouseClicked(MouseEvent evt) {
        int addr = this.convertXYtoAddr(this.mouseX, this.mouseY);
        if (addr >= 0) {
            MetaCheats.singleton.addWatches(addr, addr);
        }
    }

    private int convertXYtoAddr(int x, int y) {
        int offset = x / this.zoomAmount;
        if (offset < 0 || offset > this.columns) {
            return -1;
        }
        int row = y / this.zoomAmount;
        int addr = this.startAddress + row * this.columns + offset;
        if (addr > this.endAddress) {
            return -1;
        }
        return addr;
    }

    private String spaceFill(String s, int size) {
        while (s.length() < size) {
            s = s + " ";
        }
        return s;
    }

    private void updateDetails() {
        final JLabel status = MemorySpy.singleton.statusLabel;
        if (this.mousePresent) {
            final int addr = this.convertXYtoAddr(this.mouseX, this.mouseY);
            if (addr >= 0) {
                final int value = Computer.getComputer().getMemory().readRaw(addr) & 0xFF;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Integer lastChange = MemorySpyGrid.this.setBy.get(addr);
                        Integer lastRead = MemorySpyGrid.this.readBy.get(addr);
                        char c1 = (char)Math.max(32, value & 0x7F);
                        char c2 = (char)(64 + value % 32);
                        char c3 = (char)(32 + value % 96);
                        status.setText("$" + MemorySpyGrid.this.spaceFill(Integer.toHexString(addr), 4) + ": " + MemorySpyGrid.this.spaceFill(String.valueOf(value), 3) + " ($" + MemorySpyGrid.this.spaceFill(Integer.toHexString(value), 2) + ") " + c1 + " " + c2 + " " + c3 + (lastChange != null ? " Written by $" + MemorySpyGrid.this.spaceFill(Integer.toHexString(lastChange), 4) : "") + (lastRead != null ? " Read by $" + MemorySpyGrid.this.spaceFill(Integer.toHexString(lastRead), 4) : ""));
                    }
                });
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    status.setText("Nothing selected");
                }
            });
        }
    }

    void setDisplayMode(Modes newMode) {
        this.stopDisplay();
        this.mode = newMode;
        this.repaint();
        this.startDisplay();
    }

    void setZoomAmount(int value) {
        this.zoomAmount = value;
        this.recalibrate();
    }

    void updateRange(int startAddr, int endAddr) {
        this.startAddress = startAddr;
        this.endAddress = endAddr;
        this.activeRam.clear();
        this.valueActivity.clear();
        this.readActivity.clear();
        this.writeActivity.clear();
        this.pcActivity.clear();
        this.recalibrate();
    }

    public void adjustSize() {
        int newWidth = this.getParent().getWidth();
        if (newWidth == this.lastKnownWidth && this.getParent().getHeight() == this.lastKnownHeight) {
            return;
        }
        this.lastKnownWidth = newWidth;
        this.lastKnownHeight = this.getParent().getHeight();
        this.recalibrate();
    }

    public void recalibrate() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MemorySpyGrid.this.stopDisplay();
                int size = MemorySpyGrid.this.endAddress - MemorySpyGrid.this.startAddress + 1;
                int width = MemorySpyGrid.this.getParent().getWidth();
                MemorySpyGrid.this.columns = width / MemorySpyGrid.this.zoomAmount / 16 * 16;
                int height = (size / MemorySpyGrid.this.columns + 1) * MemorySpyGrid.this.zoomAmount;
                MemorySpyGrid.this.setSize(width, height);
                MemorySpyGrid.this.setPreferredSize(new Dimension(width, height));
                MemorySpyGrid.this.getParent().validate();
                MemorySpyGrid.this.repaint();
                MemorySpyGrid.this.startDisplay();
            }
        });
    }

    protected void drawValue(int addr, int value, Graphics2D g) {
        int offset = addr - this.startAddress;
        int x = this.zoomAmount * (offset % this.columns);
        int y = this.zoomAmount * (offset / this.columns);
        g.setColor(this.gradient[value &= 0xFF]);
        g.fillRect(x, y, this.zoomAmount, this.zoomAmount);
    }

    protected void drawActivity(int addr, int read, int write, int pc, Graphics2D g) {
        int offset = addr - this.startAddress;
        int x = this.zoomAmount * (offset % this.columns);
        int y = this.zoomAmount * (offset / this.columns);
        g.setColor(new Color(read & 0xFF, write & 0xFF, pc & 0xFF));
        g.fillRect(x, y, this.zoomAmount, this.zoomAmount);
    }

    private int getInt(Integer i) {
        if (i != null) {
            return i;
        }
        return 0;
    }

    void startDisplay() {
        if (this.memoryListener != null) {
            Computer.getComputer().getMemory().removeListener(this.memoryListener);
            this.memoryListener = null;
        }
        this.isDisplayActive = true;
        this.memoryListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            @Override
            protected void doConfig() {
                this.setScopeStart(MemorySpyGrid.this.startAddress);
                this.setScopeEnd(MemorySpyGrid.this.endAddress);
            }

            @Override
            protected void doEvent(RAMEvent e) {
                int addr = e.getAddress();
                if (addr < MemorySpyGrid.this.startAddress || addr > MemorySpyGrid.this.endAddress) {
                    return;
                }
                int pc = Computer.getComputer().getCpu().programCounter;
                if (e.getType() == RAMEvent.TYPE.EXECUTE || e.getType() == RAMEvent.TYPE.READ_OPERAND) {
                    if (MemorySpyGrid.this.pcActivity.containsKey(addr)) {
                        MemorySpyGrid.this.pcActivity.put(addr, Math.min(ACTIVITY_MAX, MemorySpyGrid.this.getInt(MemorySpyGrid.this.pcActivity.get(addr)) + ACTIVITY_INCREMENT));
                    } else {
                        MemorySpyGrid.this.pcActivity.put(addr, ACTIVITY_INCREMENT);
                    }
                } else if (e.getType().isRead()) {
                    if (MemorySpyGrid.this.readActivity.containsKey(addr)) {
                        MemorySpyGrid.this.readActivity.put(addr, Math.min(ACTIVITY_MAX, MemorySpyGrid.this.getInt(MemorySpyGrid.this.readActivity.get(addr)) + ACTIVITY_INCREMENT));
                    } else {
                        MemorySpyGrid.this.readActivity.put(addr, ACTIVITY_INCREMENT);
                    }
                    MemorySpyGrid.this.readBy.put(addr, pc);
                } else {
                    if (MemorySpyGrid.this.writeActivity.containsKey(addr)) {
                        MemorySpyGrid.this.writeActivity.put(addr, Math.min(ACTIVITY_MAX, MemorySpyGrid.this.getInt(MemorySpyGrid.this.writeActivity.get(addr)) + ACTIVITY_INCREMENT));
                    } else {
                        MemorySpyGrid.this.writeActivity.put(addr, ACTIVITY_INCREMENT);
                    }
                    MemorySpyGrid.this.valueActivity.put(addr, e.getNewValue());
                    MemorySpyGrid.this.setBy.put(addr, pc);
                }
                MemorySpyGrid.this.activeRam.add(addr);
            }
        };
        Computer.getComputer().getMemory().addListener(this.memoryListener);
        this.redrawThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (MemorySpyGrid.this.mode == Modes.ACTIVITY) {
                    while (MemorySpyGrid.this.isDisplayActive) {
                        MemorySpyGrid.this.updateDetails();
                        Graphics2D g = (Graphics2D)MemorySpyGrid.this.getGraphics();
                        Iterator<Integer> i = MemorySpyGrid.this.activeRam.iterator();
                        while (i.hasNext()) {
                            boolean remove = true;
                            int addr = i.next();
                            int read = MemorySpyGrid.this.getInt(MemorySpyGrid.this.readActivity.get(addr));
                            if (read <= 0) {
                                read = 0;
                            } else {
                                remove = false;
                                MemorySpyGrid.this.readActivity.put(addr, read - ACTIVITY_DECREMENT);
                            }
                            int write = MemorySpyGrid.this.getInt(MemorySpyGrid.this.writeActivity.get(addr));
                            if (write <= 0) {
                                write = 0;
                            } else {
                                remove = false;
                                MemorySpyGrid.this.writeActivity.put(addr, write - ACTIVITY_DECREMENT);
                            }
                            int pc = MemorySpyGrid.this.getInt(MemorySpyGrid.this.pcActivity.get(addr));
                            if (pc <= 0) {
                                pc = 0;
                            } else {
                                remove = false;
                                MemorySpyGrid.this.pcActivity.put(addr, pc - ACTIVITY_DECREMENT);
                            }
                            if (remove) {
                                i.remove();
                                MemorySpyGrid.this.pcActivity.remove(addr);
                                MemorySpyGrid.this.writeActivity.remove(addr);
                                MemorySpyGrid.this.readActivity.remove(addr);
                            }
                            MemorySpyGrid.this.drawActivity(addr, write, read, pc, g);
                        }
                        g.dispose();
                        try {
                            Thread.sleep(UPDATE_INTERVAL);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(MemorySpyGrid.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                } else {
                    while (MemorySpyGrid.this.isDisplayActive) {
                        MemorySpyGrid.this.updateDetails();
                        Graphics2D g = (Graphics2D)MemorySpyGrid.this.getGraphics();
                        Iterator<Integer> i = MemorySpyGrid.this.valueActivity.keySet().iterator();
                        while (i.hasNext()) {
                            int addr = i.next();
                            int value = MemorySpyGrid.this.getInt(MemorySpyGrid.this.valueActivity.get(addr));
                            i.remove();
                            MemorySpyGrid.this.drawValue(addr, value, g);
                        }
                        g.dispose();
                        try {
                            Thread.sleep(UPDATE_INTERVAL);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(MemorySpyGrid.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        });
        this.redrawThread.setName("Memory spy redraw");
        this.redrawThread.start();
    }

    void stopDisplay() {
        this.isDisplayActive = false;
        if (this.memoryListener != null) {
            Computer.getComputer().getMemory().removeListener(this.memoryListener);
            this.memoryListener = null;
        }
        if (this.redrawThread != null && this.redrawThread.isAlive()) {
            try {
                this.redrawThread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MemorySpyGrid.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void setColorGradient(boolean useColor) {
        this.gradient = useColor ? colorGradient : bwGradient;
        this.repaint();
    }

    void setFastFade(boolean fast) {
        ACTIVITY_DECREMENT = fast ? 20 : 5;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            float hue = (float)i / 360.0f;
            MemorySpyGrid.colorGradient[i] = Color.getHSBColor(0.67f - hue, 1.0f, 1.0f);
            MemorySpyGrid.bwGradient[i] = new Color(i, i, i);
        }
        UPDATE_INTERVAL = 10;
        ACTIVITY_INCREMENT = 150;
        ACTIVITY_DECREMENT = 5;
        ACTIVITY_MAX = 255;
    }

    public static enum Modes {
        ACTIVITY,
        VALUE;

    }
}

